package com.system.transfer.kingdee;

import com.system.utils.StringUtil;

/**
 * @author Inori
 */
public class SynchronizationRecordsListInVo {

    /**
     * 同步记录主键
     */
    private String fid;


    /**
     * 金蝶标识
     */
    private String sFormId;


    /**
     * 唯一标识
     */
    private String queueId;


    /**
     * 同步状态（0-未同步，1-同步中，2-同步成功，3-同步失败）
     */
    private Integer status;


    /**
     * 页码
     */
    private Integer pageNo;


    /**
     * 每页数量
     */
    private Integer pageSize;


    private static final Integer DEFAULT_PAGE_NO = 1;
    private static final Integer DEFAULT_PAGE_SIZE = 20;


    public SynchronizationRecordsListInVo() {
    }

    public SynchronizationRecordsListInVo(Integer status) {
        this.status = status;
    }

    public String getFid() {
        return fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public String getsFormId() {
        return sFormId;
    }

    public void setsFormId(String sFormId) {
        this.sFormId = sFormId;
    }

    public String getQueueId() {
        return queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPageNo() {
        if (StringUtil.isNull(pageNo) || pageNo == -1) {
            return DEFAULT_PAGE_NO;
        }
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        if (StringUtil.isNull(pageSize) || pageSize == -1) {
            return DEFAULT_PAGE_SIZE;
        }
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }


}
