package com.system.framework.core.utils;

import com.system.framework.core.exception.ReflectException;

import java.lang.reflect.Field;

public class ReflectUtils {
    //enum转map
    public static Object getValueByFieldName(String fieldName, Object object){
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object obj = field.get(object);
            return obj;
        } catch (NoSuchFieldException | IllegalAccessException e) {
            throw new ReflectException("通过 " + fieldName + " 字段获取对应值失败！" + e.getMessage());
        }
    }

}
