package com.system.framework.core.utils;

import java.util.Map;
//线程共享数据工具类
public class ThreadLocalUtils {

    // jdk建议将 ThreadLocal 定义为 private static ，这样就不会有弱引用，内存泄漏的问题了
    private static ThreadLocal<Map> mapThreadLocal = new ThreadLocal<>();

    //获取当前线程的存的变量
    public static Map get() {
        return mapThreadLocal.get();
    }

    //设置当前线程的存的变量
    public static void set(Map map) {
        ThreadLocalUtils.mapThreadLocal.set(map);
    }

    //移除当前线程的存的变量
    public static void remove() {
        ThreadLocalUtils.mapThreadLocal.remove();
    }
}


