package com.system.constants;

import com.system.dao.KingDeeCommonConfigMapper;
import com.system.transfer.kingdee.KingDeeCommonConfigListOutVoRecords;
import com.system.utils.JsonUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Inori
 */
@Component
public class KingDeeCommonGetConstants {

    private Map<String, Map<String, String>> map = new ConcurrentHashMap<>();

    @Autowired
    private KingDeeCommonConfigMapper kingDeeCommonConfigMapper;


    @PostConstruct
    public void init() {
        List<KingDeeCommonConfigListOutVoRecords> recordsList = kingDeeCommonConfigMapper.kingDeeCommonConfigGetList();
        if (!CollectionUtils.isEmpty(recordsList)) {
            List<Integer> idList = recordsList.stream().map(KingDeeCommonConfigListOutVoRecords::getId).collect(Collectors.toList());
            List<Map<String, Object>> fieldMappingList = kingDeeCommonConfigMapper.kingDeeFieldMappingList(idList);
            for (KingDeeCommonConfigListOutVoRecords records : recordsList) {
                List<Map<String, Object>> tempList = fieldMappingList.stream().filter(m -> records.getId().equals(m.get("id"))).collect(Collectors.toList());
                this.map.put(records.getDocType(), this.encapsulationKingDeeFiledConfig(records, tempList));
            }
        }
    }

    public Map<String, String> get(String docType) {
        return this.map.get(docType);
    }

    public void refresh(Integer id, String docType) {
        this.map.remove(docType);

        KingDeeCommonConfigListOutVoRecords records = kingDeeCommonConfigMapper.getKingDeeCommonConfigById(id);
        if (StringUtil.isNotNull(records)) {
            List<Map<String, Object>> tempList = kingDeeCommonConfigMapper.kingDeeFieldMappingList(Stream.of(records.getId()).collect(Collectors.toList()));
            this.map.put(records.getSFormId(), this.encapsulationKingDeeFiledConfig(records, tempList));
        }
    }

    private Map<String, String> encapsulationKingDeeFiledConfig(KingDeeCommonConfigListOutVoRecords records, List<Map<String, Object>> tempList) {
        Map<String, String> temp = new HashMap<>(6);
        temp.put("productId", records.getPlatformProductRelationId().toString());
        temp.put("sFormId", records.getSFormId());
        temp.put("name", records.getName());
        temp.put("docType", records.getDocType());
        temp.put("direction", records.getDirection());
        temp.put("encapsulationFormat", String.valueOf(records.getEncapsulationFormat()));
        temp.put("entryPrimaryKeyField", records.getEntryPrimaryKeyField());
        temp.put("mesEntryName", records.getMesEntryName());
        temp.put("primaryKeyField", records.getPrimaryKeyField());
        temp.put("plugInUrl", records.getPlugInUrl());
        temp.put("customSql", records.getCustomSql());
        temp.put("kingDeeFiledDetail", JsonUtil.toString(tempList));
        return temp;
    }


}
