package com.system.controller;

import com.alibaba.fastjson.JSON;
import com.system.framework.core.excel.ExportModel;
import com.system.framework.core.excel.util.ExcelUtil;
import com.system.serivce.IKingDeeCommonGetService;
import com.system.transfer.kingdee.KingDeeDataListInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * @author Inori
 */
@Api(tags = "金蝶查询")
@RestController
@RequestMapping("/api")
public class KingDeeGetController {

    @Autowired
    private IKingDeeCommonGetService kingDeeCommonGetService;


    @ApiOperation("金蝶通用查询")
    @PostMapping("/kingdee/data/list")
    public RestResponse kingDeeDataList(@RequestBody @Validated KingDeeDataListInVo inVo) {
        return kingDeeCommonGetService.kingDeeDataList(inVo);
    }

    @ApiOperation("金蝶通用导出")
    @PostMapping("/kingdee/data/export/list")
    public void kingDeeDataExport(@RequestBody @Validated KingDeeDataListInVo inVo, HttpServletResponse response) throws IOException {

        try {
            ExportModel export = kingDeeCommonGetService.export(inVo);
            ExcelUtil.export(export, response);
        } catch (Exception e) {
            // 重置response
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            Map<String, String> map = new HashMap<>(2);
            map.put("status", "failure");
            map.put("message", "下载文件失败" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }


    @ApiOperation("金蝶通用导出All")
    @PostMapping("/kingdee/data/export/all")
    public void kingDeeDataExportAll(@RequestBody @Validated KingDeeDataListInVo inVo, HttpServletResponse response) throws IOException {
        inVo.setAll(true);
        try {
            ExportModel export = kingDeeCommonGetService.export(inVo);
            ExcelUtil.export(export, response);
        } catch (Exception e) {
            // 重置response
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            Map<String, String> map = new HashMap<>(2);
            map.put("status", "failure");
            map.put("message", "下载文件失败" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }
}
