package com.system.oauth.system.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.system.oauth.system.entity.SysUserAccount;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

public interface SysUserMapper extends BaseMapper<SysUserAccount> {
    /**
     * 根据用户名称查询
     *
     * @param userName
     * @return
     */
    @Select(" select * from sys_user where username = #{userName}")
    SysUserAccount findByUsername(@Param("userName") String userName);

    @Delete("delete from sys_user_role where user_id = #{userId}")
    void deleteRoleUserRelation(@Param("user_id") Long userId);
}