package com.system.serivce.impl;

import com.system.api.KingDeeApi;
import com.system.api.KingDeeK3CloudApi;
import com.system.dao.InitConnectParamMapper;
import com.system.model.InitConnectParam;
import com.system.serivce.ISynchronizationService;
import com.system.transfer.configure.InitConnectParamCheckInVo;
import com.system.transfer.configure.InitConnectParamCreateInVo;
import com.system.transfer.configure.InitConnectParamOutVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @author Inori
 */
@Service
public class SynchronizationServiceImpl implements ISynchronizationService {

    @Autowired
    private KingDeeApi kingDeeApi;

    @Autowired
    private InitConnectParamMapper initConnectParamMapper;


    @Override
    public InitConnectParamOutVo initConnectParam() {
        return initConnectParamMapper.initConnectParam();
    }

    @Override
    public RestResponse initConnectParamCreate(InitConnectParamCreateInVo inVo) {
        KingDeeK3CloudApi kingDeeK3CloudApi = new KingDeeK3CloudApi(inVo.getK3CloudUrl());
        Boolean flag;
        try {
            flag = kingDeeK3CloudApi.login(inVo.getDbid(), inVo.getUid(), inVo.getPwd(), inVo.getLang());
        } catch (Exception e) {
            e.printStackTrace();
            flag = false;
        }

        kingDeeApi.setFlag(flag);
        kingDeeApi.setKingDeeK3CloudApi(kingDeeK3CloudApi);
        kingDeeApi.setThirdPartyUrl(inVo.getThirdPartyUrl());

        if (!flag) {
            return RestResponse.fail("参数错误，金蝶登陆失败！");
        }

        InitConnectParam initConnectParam = new InitConnectParam();
        initConnectParam.setId(1);
        initConnectParam.setK3CloudUrl(inVo.getK3CloudUrl());
        initConnectParam.setDbid(inVo.getDbid());
        initConnectParam.setLang(inVo.getLang());
        initConnectParam.setUid(inVo.getUid());
        initConnectParam.setPwd(inVo.getPwd());
        initConnectParam.setThirdPartyUrl(inVo.getThirdPartyUrl());
        initConnectParam.setDuration(inVo.getDuration());
        initConnectParamMapper.initConnectParamCreateOrUpdate(initConnectParam);
        kingDeeApi.setInitConnectParam(initConnectParam);

        return RestResponse.success();
    }

    @Override
    public RestResponse initConnectParamCheck(InitConnectParamCheckInVo inVo) {
        KingDeeK3CloudApi kingDeeK3CloudApi = kingDeeApi.getKingDeeK3CloudApi();
        boolean flag = false;
        try {
            Object[] data = new Object[]{inVo.getDbid(), inVo.getUid(), inVo.getPwd(), inVo.getLang()};
            String result = kingDeeK3CloudApi.execute("Kingdee.BOS.WebApi.ServicesStub.AuthService.ValidateUser", data, String.class);

            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (!CollectionUtils.isEmpty(map)) {
                flag = map.containsKey("LoginResultType") && Integer.parseInt(String.valueOf(map.get("LoginResultType"))) == 1;
            }
        } catch (Exception e) {
            flag = false;
        }

        if (flag) {
            return RestResponse.success("参数正确，金蝶云登陆成功");
        } else {
            return RestResponse.fail("参数错误，金蝶云登陆失败");
        }
    }


}
