package com.system.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;

/**
 * @author Inori
 */
public class LocalMacUtil {

    public static String getLocalMac(InetAddress inetAddress) throws SocketException {
        //获取网卡，获取地址
        byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();

        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < mac.length; i++) {
            if (i != 0) {
                stringBuilder.append("-");
            }
            //字节转换为整数
            int temp = mac[i] & 0xff;
            String str = Integer.toHexString(temp);
            if (str.length() == 1) {
                stringBuilder.append("0").append(str);
            } else {
                stringBuilder.append(str);
            }
        }
        return stringBuilder.toString().toUpperCase();
    }


}