package com.system.controller;

import com.alibaba.fastjson.JSON;
import com.system.framework.core.excel.ExportModel;
import com.system.framework.core.excel.util.ExcelUtil;
import com.system.serivce.IKingDeeCommonGetService;
import com.system.transfer.kingdee.KingDeeDataListInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * @author Inori
 */
@Api(tags = "金蝶查询")
@RestController
@RequestMapping("/api")
public class KingDeeGetController {

    @Autowired
    private IKingDeeCommonGetService kingDeeCommonGetService;


    @ApiOperation("金蝶通用查询")
    @PostMapping("/kingdee/data/list")
    public RestResponse kingDeeDataList(@RequestBody @Validated KingDeeDataListInVo inVo) {
        return kingDeeCommonGetService.kingDeeDataList(inVo);
    }

    @ApiOperation("金蝶通用导出")
    @PostMapping("/kingdee/data/export/list")
    public void kingDeeDataExport(@RequestBody @Validated KingDeeDataListInVo inVo, HttpServletResponse response) throws IOException {

        try {
            ExportModel export = new ExportModel();
            export.setName(inVo.getDocType());
            export.setDataList(dataList());
            export.setHead(head());
//            ExportModel export = kingDeeCommonGetService.export(inVo);
            ExcelUtil.export(export, response);
        } catch (Exception e) {
            // 重置response
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            Map<String, String> map = new HashMap<>(2);
            map.put("status", "failure");
            map.put("message", "下载文件失败" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }

    private List<List<String>> head() {
        List<List<String>> list = new ArrayList<>();
        List<String> head0 = new ArrayList<>();
        head0.add("字符串" + System.currentTimeMillis());
        List<String> head1 = new ArrayList<>();
        head1.add("数字" + System.currentTimeMillis());
        List<String> head2 = new ArrayList<>();
        head2.add("日期" + System.currentTimeMillis());
        list.add(head0);
        list.add(head1);
        list.add(head2);
        return list;
    }

    private List<List<Object>> dataList() {
        List<List<Object>> list = new ArrayList<>();
        for (int i = 0; i < 10; i++) {
            List<Object> data = new ArrayList<>();
            data.add("字符串" + i);
            data.add(new Date());
            data.add(0.56);
            list.add(data);
        }
        return list;
    }

    @ApiOperation("金蝶通用导出All")
    @PostMapping("/kingdee/data/export/all")
    public void kingDeeDataExportAll(@RequestBody @Validated KingDeeDataListInVo inVo, HttpServletResponse response) throws IOException {
        inVo.setAll(true);
        try {
//            ExportModel export = kingDeeCommonGetService.export(inVo);
            ExportModel export = new ExportModel();
            export.setName(inVo.getDocType());
            export.setDataList(dataList());
            export.setHead(head());
            ExcelUtil.export(export, response);
        } catch (Exception e) {
            // 重置response
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            Map<String, String> map = new HashMap<>(2);
            map.put("status", "failure");
            map.put("message", "下载文件失败" + e.getMessage());
            response.getWriter().println(JSON.toJSONString(map));
        }
    }
}
