package com.system.enums;

/**
 * @author Inori
 */
public enum OperationEnum {

    /**
     * 剔除类型
     */
    SELECT(1, "查询"),
    CREATE_OR_UPDATE(2, "创建/更新"),
    SYNCHRONIZATION(3, "同步");

    private final Integer key;

    private final String value;


    OperationEnum(Integer key, String value) {
        this.key = key;
        this.value = value;
    }


    public Integer getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

    public static String getValue(Integer operation) {
        for (OperationEnum operationEnum : OperationEnum.values()) {
            if (operation.equals(operationEnum.getKey())) {
                return operationEnum.getValue();
            }
        }
        return "";
    }


}
