package com.system.controller;

import com.system.serivce.IDockingService;
import com.system.transfer.docking.DockingDistributionMemberBalanceInVo;
import com.system.transfer.docking.DockingDistributionMemberCreateInVo;
import com.system.transfer.docking.DockingDistributionMemberSubordinateListInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class DockingController {

    @Autowired
    private IDockingService dockingService;


    @ApiOperation("分销会员创建")
    @PostMapping("/docking/distribution/member/create")
    public RestResponse dockingDistributionMemberCreate(@RequestBody DockingDistributionMemberCreateInVo inVo) {
        return dockingService.dockingDistributionMemberCreate(inVo);
    }

    @ApiOperation("分销会员创建")
    @GetMapping("/docking/distribution/member/subordinate/list")
    public RestResponse dockingDistributionMemberSubordinateList(@RequestBody DockingDistributionMemberSubordinateListInVo inVo) {
        return dockingService.dockingDistributionMemberSubordinateList(inVo);
    }

    @ApiOperation("分销会员余额")
    @GetMapping("/docking/distribution/member/balance")
    public RestResponse dockingDistributionMemberBalance(@RequestBody DockingDistributionMemberBalanceInVo inVo) {
        return dockingService.dockingDistributionMemberBalance(inVo);
    }


}
