package com.system.oauth.system.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotBlank;
import java.util.Date;
import java.util.List;

@ApiModel(value = "注册对象", description = "注册对象")
@Data
public class RegisterModel {

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名(必填)")
    @NotBlank(message = "name not blank")
    private String name;

    /**
     * 头像地址
     */
    @ApiModelProperty(value = "头像")
    private String Favatar;
    /** 1. 用户名不能为纯数字 2. 由数字字母下划线 4-16位组成
     * 账号
     */

    @ApiModelProperty(value = "用户账号(必填)")
    @NotBlank(message = "Account not blank")
    private String fauthAccount;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码(必填)")
    @NotBlank(message = "password not blank")
    private String password;
    /**
     * 用户介绍
     */
    @ApiModelProperty(value = "用户介绍")
    private String introduction;
    /**
     * 英文名
     */
    @ApiModelProperty(value = "英文名")
    private String fenglishName;
    /**
     * 工号
     */
    @ApiModelProperty(value = "工号")
    private String fworkNo;

    /**
     * 部门
     */
    @ApiModelProperty(value = "部门")
    private String fdept;
    /**
     * 手机
     */
    @ApiModelProperty(value = "手机")
    private String fphone;
    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱")
    private String fmail;
    /**
     * 工作地点
     */
    @ApiModelProperty(value = "工作地点")
    private String fworkAddr;

    /**
     * 入职日期
     */
    @ApiModelProperty(value = "入职日期")
    private Date finductionDate;
    /**
     * 职位
     */
    @ApiModelProperty(value = "职位")
    private String fposition;
    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String fstate;
    //创建日期
    @ApiModelProperty(value = "创建日期")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date fdate;
    //    创建人
    @ApiModelProperty(value = "创建人")
    private String fcreator;
    
    private List<String> roles;
}
