package com.system.quartz.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.quartz.model.QuartzJob;
import com.system.quartz.transfer.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface QuartzJobMapper extends BaseMapper<QuartzJob> {

    /**
     * 定时任务列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<QuartzJobOutVoRecords> quartzJobList(@Param("page") Page<QuartzJobOutVoRecords> page, @Param("inVo") QuartzJobListInVo inVo);

    /**
     * 根据任务名称判断是否存在
     *
     * @param jobClassName 任务名称
     * @param id           ID
     * @return 1 或 0
     */
    Integer getByJobClassName(@Param("jobClassName") String jobClassName, @Param("id") Integer id);

    /**
     * 定时任务录入
     *
     * @param inVo 条件
     */
    void quartzJobCreate(QuartzJobCreateInVo inVo);

    /**
     * 定时任务更新
     *
     * @param inVo 条件
     */
    void quartzJobUpdate(QuartzJobUpdateInVo inVo);

    /**
     * 根据ID查询任务名称
     *
     * @param id ID
     * @return 任务名称
     */
    String getJobClassNameById(Integer id);

    /**
     * 定时任务删除
     *
     * @param id ID
     */
    void quartzJobDelete(Integer id);

    /**
     * 更新定时任务状态
     *
     * @param jobClassName 任务名称
     * @param status       状态
     */
    void updateStatusByJobClassName(@Param("jobClassName") String jobClassName, @Param("status") Integer status);

    /**
     * 根据任务名称查询定时任务
     *
     * @param jobClassName 任务名称
     * @return 定时任务
     */
    QuartzJobOutVoRecords getQuartzJobByJobClassName(String jobClassName);


}
