package com.system.quartz.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.system.transfer.response.RestResponse;
import com.system.quartz.model.QuartzJob;
import com.system.quartz.transfer.*;

/**
 * @author Inori
 */
public interface IQuartzJobService extends IService<QuartzJob> {

    /**
     * 定时任务列表
     *
     * @param inVo 条件
     * @return 列表
     */
    QuartzJobListOutVo quartzJobList(QuartzJobListInVo inVo);

    /**
     * 定时任务录入
     *
     * @param inVo 条件
     * @return 录入结果
     */
    RestResponse quartzJobCreate(QuartzJobCreateInVo inVo);

    /**
     * 定时任务更新
     *
     * @param inVo 条件
     * @return 更新结果
     */
    RestResponse quartzJobUpdate(QuartzJobUpdateInVo inVo);

    /**
     * 定时任务删除
     *
     * @param inVo 条件
     * @return 删除结果
     */
    RestResponse quartzJobDelete(QuartzJobDeleteInVo inVo);

    /**
     * 定时任务启动
     *
     * @param inVo 条件
     * @return 启动结果
     */
    RestResponse quartzJobResume(QuartzJobResumeInVo inVo);

    /**
     * 定时任务暂停
     *
     * @param inVo 条件
     * @return 暂停结果
     */
    RestResponse quartzJobPause(QuartzJobPauseInVo inVo);


}
