package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.serivce.IDockingDistributionService;
import com.system.transfer.response.RestResponse;
import com.system.utils.HttpClientUtil;
import com.system.utils.JsonUtil;
import com.system.utils.ThirdPartyLogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class DockingDistributionServiceImpl implements IDockingDistributionService {

    private String secret;

    @Autowired
    private ThirdPartyLogUtil thirdPartyLogUtil;


    @PostConstruct
    public void init() {
        String result = HttpClientUtil.sendGet("http://192.168.0.34:8080/api/v1/getSign");
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            this.secret = String.valueOf(map.get("data"));
        }
    }

    @Override
    public String dockingDistributionMemberCreate(Map<String, Object> data, String queueId) {
        try {
            data.put("secret", secret);
            String result = HttpClientUtil.sendPost("http://192.168.0.34:8080/api/v1/memberAdd", JsonUtil.toString(data));

            thirdPartyLogUtil.thirdPartyLogCreate("分销会员创建", "0001", queueId, "平台->分销", JsonUtil.toString(data), result, 1);
            return result;
        } catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public RestResponse dockingDistributionTransactionCreate() {
        try {
            Map<String, Object> data = new HashMap<>();
            data.put("secret", secret);
            data.put("disSetUserId", "1111");
            data.put("orderId", "5555");
            data.put("disAmount", "12");
            data.put("disNote", "");
            String result = HttpClientUtil.sendPost("http://192.168.0.34:8080/api/v1/trade", JsonUtil.toString(data));

            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                return RestResponse.fail("新增交易失败");
            }
            return RestResponse.success();
        } catch (IOException e) {
            e.printStackTrace();
            return RestResponse.fail("新增交易失败");
        }
    }

    @Override
    public RestResponse dockingDistributionWithdrawalCreate() {
        try {
            Map<String, Object> data = new HashMap<>();
            data.put("secret", secret);
            data.put("userId", "admin");
            data.put("amount", "1");
            data.put("accountType", "2");
            String result = HttpClientUtil.sendPost("http://192.168.0.34:8080/api/v1/withdraw", JsonUtil.toString(data));

            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                return RestResponse.fail("新增提现失败");
            }
            return RestResponse.success();
        } catch (IOException e) {
            e.printStackTrace();
            return RestResponse.fail("新增提现失败");
        }
    }

    @Override
    public String dockingDistributionMemberSubordinateList(String queueId, String memberId) {
        try {
            Map<String, Object> data = new HashMap<>(2);
            data.put("secret", secret);
            data.put("memberId", memberId);
            String result = HttpClientUtil.sendPost("http://192.168.0.34:8080/api/v1/subordinate", JsonUtil.toString(data));

            thirdPartyLogUtil.thirdPartyLogCreate("分销会员下级查询", "0001", queueId, "平台->分销", JsonUtil.toString(data), result, 1);
            return result;
        } catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }


}
