package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.serivce.IDockingDistributionService;
import com.system.serivce.IDockingService;
import com.system.transfer.docking.DockingDistributionMemberCreateInVo;
import com.system.transfer.docking.DockingDistributionMemberSubordinateListInVo;
import com.system.transfer.response.RestResponse;
import com.system.utils.JsonUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class DockingServiceImpl implements IDockingService {

    @Autowired
    private IDockingDistributionService dockingDistributionService;


    @Override
    public RestResponse dockingDistributionMemberCreate(DockingDistributionMemberCreateInVo inVo) {
        Map<String, Object> data = new HashMap<>();
        data.put("disUserId", inVo.getMemberId());
        data.put("disUserName", inVo.getMemeberName());
        data.put("disParentId", inVo.getReferrerId());
        data.put("disPlatformId", inVo.getPlatformId());
        data.put("disNote", inVo.getRemark());

        String result = dockingDistributionService.dockingDistributionMemberCreate(data, inVo.getQueueId());
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (CollectionUtils.isEmpty(map) || !Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            return RestResponse.fail("新增会员失败");
        }

        return RestResponse.success();
    }

    @Override
    public RestResponse dockingDistributionMemberSubordinateList(DockingDistributionMemberSubordinateListInVo inVo) {
        String result = dockingDistributionService.dockingDistributionMemberSubordinateList(inVo.getQueueId(), inVo.getMemberId());

        List<Map<String, Object>> recordsList = new ArrayList<>();
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            List<Object> objectList = JsonUtil.toList(JsonUtil.toString(map.get("data")), Object.class);
            List<Map<String, Object>> tempList = objectList.stream().map(m -> JsonUtil.toMap(JsonUtil.toString(m), String.class, Object.class)).collect(Collectors.toList());

            List<Map<String, Object>> temp01List = tempList.stream().filter(m -> inVo.getMemberId().equals(m.get("parentId"))).collect(Collectors.toList());
            for (Map<String, Object> temp : temp01List) {
                List<Map<String, Object>> temp02List = tempList.stream().filter(m -> temp.get("memberId").equals(m.get("parentId"))).collect(Collectors.toList());
                recordsList.add(temp);
                recordsList.addAll(temp02List);
            }
        }

        return RestResponse.success(recordsList);
    }


}
