package com.system.serivce.impl;

import com.system.constants.Constants;
import com.system.serivce.IDockingShoppingMallService;
import com.system.utils.HttpClientUtil;
import com.system.utils.JsonUtil;
import com.system.utils.ThirdPartyLogUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Inori
 */
@Service
public class DockingShoppingMallServiceImpl implements IDockingShoppingMallService {

    @Autowired
    private ThirdPartyLogUtil thirdPartyLogUtil;


    @Override
    public String shoppingMallOrderList() {
        Map<String, Object> data = new HashMap<>(2);
        data.put("startTime", "2019-01-01+00:00:00");
        data.put("endTime", "2022-10-12+23:59:59");

        StringBuilder param = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        String result = HttpClientUtil.sendGet("http://192.168.2.212:81/apis/order/order/page?current=1&size=100" + param.toString());

        System.out.println(result);

        return result;
    }

    @Override
    public void shoppingMallProductList() {
        Map<String, Object> data = new HashMap<>(2);
        data.put("startTime", "2019-01-01+00:00:00");
        data.put("endTime", "2022-10-12+23:59:59");

        StringBuilder param = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        String result = HttpClientUtil.sendGet("http://192.168.2.212:81/apis/prod/prod/page?current=1&size=100" + param.toString());

        System.out.println(result);
    }

    @Override
    public String shoppingMallMemberList(String queueId) {
        Map<String, Object> data = new HashMap<>(2);
        data.put("startTime", "2019-01-01+00:00:00");
        data.put("endTime", "2022-10-12+23:59:59");

        StringBuilder param = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (param.length() > 0) {
                param.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            } else {
                param.append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        String result = HttpClientUtil.sendGet("https://console-mock.apipost.cn/app/mock/project/a0605054-5c08-47a3-e61e-76782a1bc5aa/member/list?" + param.toString());

        int flag = 0;
        Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
        if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
            flag = 1;
        }
        thirdPartyLogUtil.thirdPartyLogCreate("商城会员查询", "0000", queueId, "商城->平台", JsonUtil.toString(data), result, flag);
        return result;
    }


}
