package com.system.serivce.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.system.constants.Constants;
import com.system.serivce.IDockingDistributionService;
import com.system.serivce.IDockingShoppingMallService;
import com.system.serivce.ISynchronizationService;
import com.system.utils.JsonUtil;
import com.system.utils.SnowFlakeIdUtil;
import com.system.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author Inori
 */
@Service
public class SynchronizationServiceImpl implements ISynchronizationService {

    private ExecutorService threadPool = new ThreadPoolExecutor(10, 10,
            0L,
            TimeUnit.MILLISECONDS,
            new LinkedBlockingQueue<Runnable>(1024),
            new ThreadFactoryBuilder().setNameFormat("syn-pool-%d").build(),
            new ThreadPoolExecutor.AbortPolicy());

    @Autowired
    private IDockingShoppingMallService dockingShoppingMallService;

    @Autowired
    private IDockingDistributionService dockingDistributionService;


    @Override
    public void synchronization() {
        threadPool.execute(() -> {
            String queueId = SnowFlakeIdUtil.generateId().toString();
            Map<String, Object> request = new HashMap<>(3);

            String result = dockingShoppingMallService.shoppingMallMemberList(queueId);
            Map<String, Object> map = JsonUtil.toMap(result, String.class, Object.class);
            if (!CollectionUtils.isEmpty(map) && Constants.SUCCESS_CODE.equals(String.valueOf(map.get(Constants.SUCCESS_NAME)))) {
                Map<String, Object> data = JsonUtil.toMap(JsonUtil.toString(map.get("data")), String.class, Object.class);
                List<Object> objectList = JsonUtil.toList(JsonUtil.toString(data.get("records")), Object.class);
                if (!CollectionUtils.isEmpty(objectList)) {
                    for (Object o : objectList) {
                        Map<String, Object> temp = JsonUtil.toMap(JsonUtil.toString(o), String.class, Object.class);
                        request.put("disUserId", temp.get("userId").toString());
                        request.put("disUserName", temp.get("nickName"));
                        if (temp.containsKey("referrerId") && StringUtil.isNotBlank(String.valueOf(temp.get("referrerId")))) {
                            request.put("disParentId", temp.get("referrerId"));
                            request.put("disPlatformId", "");
                        } else {
                            request.put("disParentId", "");
                            request.put("disPlatformId", "test");
                        }
                        request.put("disNote", "");
                    }
                }
            }

            if (!CollectionUtils.isEmpty(request)) {
                dockingDistributionService.dockingDistributionMemberCreate(request, queueId);
            }
        });
    }


}
