package com.system.controller;

import com.system.serivce.ICommonHttpService;
import com.system.transfer.platform.PlatformDockingShoppingMallCommodityInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@RestController
@RequestMapping("/api")
public class CommonHttpController {

    @Autowired
    private ICommonHttpService commonHttpService;

    @ApiOperation("触发平台对接商城会员")
    @GetMapping("/docking/shopping/mall/member")
    public RestResponse dockingShoppingMallMember() {
        return RestResponse.success();
    }

    @ApiOperation("触发平台对接商品")
    @PostMapping("/docking/shopping/mall/commodity")
    public RestResponse dockingShoppingMallCommodity(@RequestBody PlatformDockingShoppingMallCommodityInVo inVo) {
        commonHttpService.dockingShoppingMallCommodity(inVo);
        return RestResponse.success();
    }


}
