package com.system.controller;

import com.system.serivce.ICustomFormConfigService;
import com.system.transfer.form.*;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "自定义表单配置")
@RestController
@RequestMapping("/api")
public class CustomFormConfigController {

    @Autowired
    private ICustomFormConfigService customFormConfigService;


    @ApiOperation("自定义表单配置列表")
    @GetMapping("/custom/form/config/list")
    public RestResponse customFormConfigList(@ModelAttribute CustomFormConfigListInVo inVo) {
        CustomFormConfigListOutVo outVo = customFormConfigService.customFormConfigList(inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("自定义表单配置创建")
    @PostMapping("/custom/form/config/create")
    public RestResponse customFormConfigCreate(@RequestBody CustomFormConfigCreateInVo inVo) {
        customFormConfigService.customFormConfigCreate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("自定义表单配置更新")
    @PutMapping("/custom/form/config/update")
    public RestResponse customFormConfigUpdate(@RequestBody CustomFormConfigUpdateInVo inVo) {
        customFormConfigService.customFormConfigUpdate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("自定义表单配置删除")
    @DeleteMapping("/custom/form/config/delete")
    public RestResponse customFormConfigDelete(@RequestBody CustomFormConfigDeleteInVo inVo) {
        customFormConfigService.customFormConfigDelete(inVo);
        return RestResponse.success();
    }


}
