package com.system.controller;

import com.system.serivce.IFormFieldMappingDetailService;
import com.system.transfer.form.FormFieldMappingDetailCreateInVo;
import com.system.transfer.form.FormFieldMappingDetailDeleteInVo;
import com.system.transfer.form.FormFieldMappingDetailUpdateInVo;
import com.system.transfer.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "表单字段映射")
@RestController
@RequestMapping("/api")
public class FormFieldMappingDetailController {

    @Autowired
    private IFormFieldMappingDetailService formFieldMappingDetailService;


    @ApiOperation("表单字段映射明细创建")
    @PostMapping("/form/field/mapping/detail/create")
    public RestResponse formFieldMappingDetailCreate(@RequestBody FormFieldMappingDetailCreateInVo inVo) {
        formFieldMappingDetailService.formFieldMappingDetailCreate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("表单字段映射明细更新")
    @PutMapping("/form/field/mapping/detail/update")
    public RestResponse formFieldMappingDetailUpdate(@RequestBody FormFieldMappingDetailUpdateInVo inVo) {
        formFieldMappingDetailService.formFieldMappingDetailUpdate(inVo);
        return RestResponse.success();
    }

    @ApiOperation("表单字段映射明细删除")
    @DeleteMapping("/form/field/mapping/detail/delete")
    public RestResponse formFieldMappingDetailDelete(@RequestBody FormFieldMappingDetailDeleteInVo inVo) {
        formFieldMappingDetailService.formFieldMappingDetailDelete(inVo);
        return RestResponse.success();
    }


}
