package com.system.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.transfer.form.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface CustomFormConfigMapper {

    /**
     * 自定义表单配置列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<CustomFormConfigListOutVoRecords> customFormConfigList(@Param("page") Page<CustomFormConfigListOutVoRecords> page, @Param("inVo") CustomFormConfigListInVo inVo);

    /**
     * 自定义表单配置创建
     *
     * @param inVo 条件
     */
    void customFormConfigCreate(CustomFormConfigCreateInVo inVo);

    /**
     * 自定义表单配置更新
     *
     * @param inVo 条件
     */
    void customFormConfigUpdate(CustomFormConfigUpdateInVo inVo);

    /**
     * 自定义表单配置删除
     *
     * @param inVo 条件
     */
    void customFormConfigDelete(CustomFormConfigDeleteInVo inVo);


}
