package com.system.oauth.system;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletRequest;

@Slf4j
public class QueryWrapperGenerator {
    /**
     * 获取查询条件构造器QueryWrapper实例 通用查询条件已被封装完成
     * @param searchObj 查询实体
     * @param  request request.getParameter()
     * @return QueryWrapper实例
     */
    public static <T> QueryWrapper<T> initQueryWrapper(T searchObj, HttpServletRequest request){
        long start = System.currentTimeMillis();
        QueryWrapper<T> queryWrapper = new QueryWrapper<T>();
        installLimit(queryWrapper, request);
        log.debug("---查询条件构造器初始化完成,耗时:"+(System.currentTimeMillis()-start)+"毫秒----");
        return queryWrapper;
    }
    public static void installLimit(QueryWrapper<?> queryWrapper,HttpServletRequest request) {
        queryWrapper.last("limit "+request.getParameter("pageNo")+", "+request.getParameter("pageSize"));
    }
}
