package com.system.serivce.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.system.dao.CustomFormConfigMapper;
import com.system.serivce.ICustomFormConfigService;
import com.system.transfer.form.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author Inori
 */
@Service
public class CustomFormConfigServiceImpl implements ICustomFormConfigService {

    @Autowired
    private CustomFormConfigMapper customFormConfigMapper;


    @Override
    public CustomFormConfigListOutVo customFormConfigList(CustomFormConfigListInVo inVo) {
        Page<CustomFormConfigListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<CustomFormConfigListOutVoRecords> recordsList = customFormConfigMapper.customFormConfigList(page, inVo);

        /*List<Integer> idList = recordsList.stream().map(CustomFormConfigListOutVoRecords::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(idList)) {
            List<FormFieldMappingDetailOutVoRecords> tempList = formFieldMappingDetailMapper.formFieldMappingDetailList(new FormFieldMappingDetailListInVo(idList));
            recordsList.forEach(m -> {
                List<FormFieldMappingDetailOutVoRecords> collectList = tempList.stream().filter(n -> m.getId().equals(n.getCustomFormConfigId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectList)) {
                    m.setFormFieldMappingDetail(JsonUtil.toString(collectList));
                }
            });
        }*/

        CustomFormConfigListOutVo outVo = new CustomFormConfigListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public void customFormConfigCreate(CustomFormConfigCreateInVo inVo) {
        customFormConfigMapper.customFormConfigCreate(inVo);
    }

    @Override
    public void customFormConfigUpdate(CustomFormConfigUpdateInVo inVo) {
        customFormConfigMapper.customFormConfigUpdate(inVo);
    }

    @Override
    public void customFormConfigDelete(CustomFormConfigDeleteInVo inVo) {
        customFormConfigMapper.customFormConfigDelete(inVo);
    }


}
