package com.auth.controller;

import com.auth.common.controller.BaseRestController;
import com.core.response.RestResponse;
import com.auth.serivce.IDeptService;
import com.auth.transfer.dept.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "部门管理")
@RestController
@RequestMapping("/api")
public class DeptController extends BaseRestController {

    @Autowired
    private IDeptService deptService;


    @ApiOperation("部门列表")
    @GetMapping("/dept/list")
    public RestResponse deptList(@ModelAttribute @Validated DeptListInVo inVo) {
        DeptListOutVo outVo = deptService.deptList(this, inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("录入部门")
    @PostMapping("/dept/create")
    public RestResponse deptCreate(@RequestBody @Validated DeptCreateInVo inVo) {
        inVo.setCreateBy(getUser().getName());
        deptService.deptCreate(this, inVo);
        return RestResponse.success();
    }

    @ApiOperation("修改部门")
    @PutMapping("/dept/update")
    public RestResponse deptUpdate(@RequestBody @Validated DeptUpdateInVo inVo) {
        inVo.setUpdateBy(getUser().getName());
        deptService.deptUpdate(this, inVo);
        return RestResponse.success();
    }

    @ApiOperation("删除部门")
    @DeleteMapping("/dept/delete")
    public RestResponse deptDelete(@ModelAttribute @Validated DeptDeleteInVo inVo) {
        deptService.deptDelete(this, inVo);
        return RestResponse.success();
    }


}
