package com.auth.dao;

import com.auth.model.User;
import com.auth.transfer.user.UserInfoOutVo;
import com.auth.transfer.user.UserListInVo;
import com.auth.transfer.user.UserListOutVoRecords;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.repository.query.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface UserMapper extends BaseMapper<User> {

    /**
     * 用户列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<UserListOutVoRecords> userList(@Param("page") Page<UserListOutVoRecords> page, @Param("inVo") UserListInVo inVo);

    /**
     * 用户信息
     *
     * @param userId 用户ID
     * @return 用户信息
     */
    UserInfoOutVo userInfo(Integer userId);


}
