package com.auth.serivce;

import com.auth.common.controller.BaseRestController;
import com.auth.model.User;
import com.auth.transfer.user.*;
import com.baomidou.mybatisplus.extension.service.IService;
import com.core.response.RestResponse;

/**
 * @author Inori
 */
public interface IUserService extends IService<User> {

    /**
     * 用户列表
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 列表
     */
    UserListOutVo userList(BaseRestController controller, UserListInVo inVo);

    /**
     * 用户录入
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse userCreate(BaseRestController controller, UserCreateInVo inVo);

    /**
     * 用户编辑
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse userUpdate(BaseRestController controller, UserUpdateInVo inVo);

    /**
     * 用户删除
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse userDelete(BaseRestController controller, UserDeleteInVo inVo);

    /**
     * 用户登陆信息
     *
     * @param controller 枷锁
     * @param userId     ID
     * @return 登陆信息
     */
    UserInfoOutVo userInfo(BaseRestController controller, Integer userId);

    /**
     * 用户登录权限
     *
     * @param controller 枷锁
     * @param userId     ID
     * @return 登录权限
     */
    UserPermissionOutVo userPermission(BaseRestController controller, Integer userId);

    /**
     * 修改密码
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse userPasswordUpdate(BaseRestController controller, UserPasswordUpdateInVo inVo);


}
