package com.auth.serivce.impl;

import com.core.constants.Constants;
import com.auth.common.controller.BaseRestController;
import com.auth.dao.MenuMapper;
import com.auth.model.Menu;
import com.auth.serivce.IMenuService;
import com.auth.transfer.menu.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class MenuServiceImpl implements IMenuService {

    @Autowired
    private MenuMapper menuMapper;


    @Override
    public MenuListOutVo menuList(BaseRestController baseRestController, MenuListInVo inVo) {
        List<MenuListOutVoRecords> recordsList = menuMapper.menuList(inVo);

        MenuListOutVo outVo = new MenuListOutVo();
        outVo.setTotal(recordsList.size());
        outVo.setRecords(getMenuTree(String.valueOf(Constants.ROOT_MENU_CODE), recordsList));
        return outVo;
    }

    private List<MenuListOutVoRecords> getMenuTree(String pcode, List<MenuListOutVoRecords> recordsList) {
        List<MenuListOutVoRecords> rootList = recordsList.stream().filter(m ->
                m.getPcode().equals(pcode)).collect(Collectors.toList()
        );

        for (MenuListOutVoRecords records : rootList) {
            records.setChildren(getMenuTree(records.getCode(), recordsList));
        }
        return rootList;
    }

    @Override
    public void menuCreate(BaseRestController baseRestController, MenuCreateInVo inVo) {
        Menu menu = new Menu();
        menu.setCode(inVo.getCode());
        menu.setPcode(inVo.getPcode());
        menu.setName(inVo.getName());
        menu.setPath(inVo.getPath());
        menu.setIcon(inVo.getIcon());
        menu.setAssembly(inVo.getAssembly());
        menu.setSortOrder(inVo.getSortOrder());
        menu.setLevel(inVo.getLevel());
        menu.setType(inVo.getType());
        menu.setDesc(inVo.getDesc());
        menu.setStatus(inVo.getStatus());
        menu.setCreateBy(inVo.getCreateBy());
        menuMapper.insert(menu);
    }

    @Override
    public void menuUpdate(BaseRestController baseRestController, MenuUpdateInVo inVo) {
        Menu menu = new Menu();
        menu.setId(inVo.getId());
        menu.setName(inVo.getName());
        menu.setCode(inVo.getCode());
        menu.setPcode(inVo.getPcode());
        menu.setIcon(inVo.getIcon());
        menu.setAssembly(inVo.getAssembly());
        menu.setPath(inVo.getPath());
        menu.setLevel(inVo.getLevel());
        menu.setSortOrder(inVo.getSortOrder());
        menu.setType(inVo.getType());
        menu.setDesc(inVo.getDesc());
        menu.setStatus(inVo.getStatus());
        menu.setCreateBy(inVo.getUpdateBy());
        menuMapper.updateById(menu);
    }

    @Override
    public void menuDelete(BaseRestController baseRestController, MenuDeleteInVo inVo) {
        menuMapper.deleteById(inVo.getId());
    }


}
