package com.auth.serivce.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.core.constants.Constants;
import com.auth.common.controller.BaseRestController;
import com.core.response.RestResponse;
import com.auth.dao.RoleMapper;
import com.auth.dao.UserMapper;
import com.auth.dao.UserRoleMapper;
import com.auth.model.Menu;
import com.auth.model.User;
import com.auth.model.UserRole;
import com.auth.serivce.IUserService;
import com.auth.transfer.user.*;
import com.auth.utils.Md5Util;
import com.core.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class UserServiceImpl extends ServiceImpl<UserMapper, User> implements IUserService {

    @Autowired
    private UserMapper userMapper;

    @Autowired
    private UserRoleMapper userRoleMapper;

    @Autowired
    private RoleMapper roleMapper;


    @Override
    public UserListOutVo userList(BaseRestController controller, UserListInVo inVo) {
        Page<UserListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<UserListOutVoRecords> recordsList = userMapper.userList(page, inVo);

        UserListOutVo outVo = new UserListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse userCreate(BaseRestController controller, UserCreateInVo inVo) {
        User user = new User();
        user.setDeptId(inVo.getDeptId());
        user.setAccount(inVo.getAccount());
        user.setSalt(inVo.getAccount());
        user.setPassword(inVo.getPassword());
        user.setName(inVo.getName());
        user.setMobile(inVo.getMobile());
        user.setAddress(inVo.getAddress());
        user.setStatus(inVo.getStatus());
        user.setCreateBy(inVo.getCreateBy());
        return userHandle(user, inVo.getRoleIdList());
    }

    @Override
    public RestResponse userUpdate(BaseRestController controller, UserUpdateInVo inVo) {
        User user = new User();
        user.setId(inVo.getId());
        user.setDeptId(inVo.getDeptId());
        user.setAccount(inVo.getAccount());
        if (StringUtil.isNotBlank(inVo.getPassword())) {
            user.setPassword(Md5Util.encrypt(inVo.getPassword() + inVo.getAccount()));
        }
        user.setSalt(inVo.getAccount());
        user.setName(inVo.getName());
        user.setMobile(inVo.getMobile());
        user.setAddress(inVo.getAddress());
        user.setStatus(inVo.getStatus());
        user.setUpdateBy(inVo.getUpdateBy());
        return userHandle(user, inVo.getRoleIdList());
    }

    private RestResponse userHandle(User user, List<Integer> roleIds) {
        Integer userId = user.getId();
        if (userId == null) {
            Integer count = userMapper.selectCount(new QueryWrapper<User>()
                    .eq("account", user.getAccount())
                    .ne("status", -1));
            if (count > 0) {
                return RestResponse.fail("该账号已存在，请更换");
            }
            user.setPassword(Md5Util.encrypt(user.getPassword() + user.getAccount()));
            userMapper.insert(user);
        } else {
            Integer count = userMapper.selectCount(new QueryWrapper<User>()
                    .eq("account", user.getAccount())
                    .ne("status", -1)
                    .ne("id", userId));
            if (count > 0) {
                return RestResponse.fail("该账号已存在，请更换");
            }
            userMapper.updateById(user);
        }

        //删除原关联
        userRoleMapper.delete(new QueryWrapper<UserRole>().eq("user_id", user.getId()));
        for (Integer roleId : roleIds) {
            UserRole userRole = new UserRole();
            userRole.setRoleId(roleId);
            userRole.setUserId(user.getId());
            userRoleMapper.insert(userRole);
        }
        return RestResponse.success();
    }

    @Override
    public RestResponse userDelete(BaseRestController controller, UserDeleteInVo inVo) {
        User user = userMapper.selectById(inVo.getId());
        if (user == null || user.getStatus() == -1) {
            return RestResponse.fail("用户不存在");
        }
        if (Integer.parseInt(inVo.getMe()) == inVo.getId()) {
            return RestResponse.fail("用户无法更改自己的状态");
        }

        User temp = new User();
        temp.setId(inVo.getId());
        userMapper.updateById(temp);
        return RestResponse.success();
    }

    @Override
    public UserInfoOutVo userInfo(BaseRestController controller, Integer userId) {
        return userMapper.userInfo(userId);
    }

    @Override
    public UserPermissionOutVo userPermission(BaseRestController controller, Integer userId) {
        List<Menu> permissionList = roleMapper.getMenuListByUserId(userId);

        List<UserPermissionOutVoRootTree> allMenuList = permissionList.stream().map(menu -> {
            UserPermissionOutVoRootTree treeRoot = new UserPermissionOutVoRootTree();
            treeRoot.setId(menu.getId());
            treeRoot.setCode(menu.getCode());
            treeRoot.setPcode(menu.getPcode());
            treeRoot.setPath(menu.getPath());
            treeRoot.setName(menu.getName());
            treeRoot.setIcon(menu.getIcon());
            treeRoot.setAssembly(menu.getAssembly());
            treeRoot.setSortOrder(menu.getSortOrder());
            treeRoot.setType(menu.getType());
            return treeRoot;
        }).collect(Collectors.toList());

        UserPermissionOutVo outVo = new UserPermissionOutVo();
        outVo.setRootTree(getMenuTree(String.valueOf(Constants.ROOT_MENU_CODE), allMenuList));
        return outVo;
    }

    private List<UserPermissionOutVoRootTree> getMenuTree(String pcode, List<UserPermissionOutVoRootTree> permissionMenuList) {
        List<UserPermissionOutVoRootTree> rootList = permissionMenuList.stream().filter(m ->
                m.getPcode().equals(pcode)).collect(Collectors.toList()
        );

        for (UserPermissionOutVoRootTree treeRoot : rootList) {
            treeRoot.setChildren(getMenuTree(treeRoot.getCode(), permissionMenuList));
        }
        return rootList;
    }

    @Override
    public RestResponse userPasswordUpdate(BaseRestController controller, UserPasswordUpdateInVo inVo) {
        User user = inVo.getUser();
        String password = Md5Util.encrypt(inVo.getOldPassword() + user.getAccount());
        if (!user.getPassword().equals(password)) {
            return RestResponse.fail("原密码不正确，无法修改密码");
        }

        password = Md5Util.encrypt(inVo.getNewPassword() + user.getAccount());
        user.setPassword(password);
        userMapper.updateById(user);
        return RestResponse.success();
    }


}
