package com.auth.transfer.menu;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 修改菜单
 *
 * @author Inori
 */
@Data
public class MenuUpdateInVo {

    /**
     * PID
     */
    @NotNull(message = "参数id缺失")
    private Integer id;


    /**
     * 编码
     */
    @NotBlank(message = "参数code缺失")
    private String code;


    /**
     * 父编码
     */
    @NotBlank(message = "参数pcode缺失")
    private String pcode;


    /**
     * 名称
     */
    @NotBlank(message = "参数name缺失")
    private String name;


    /**
     * 路径
     */
    private String path;


    /**
     * 图标
     */
    private String icon;


    /**
     * 组件
     */
    private String assembly;


    /**
     * 排序
     */
    @NotNull(message = "参数sortOrder缺失")
    private Integer sortOrder;


    /**
     * 层级
     */
    private Integer level;


    /**
     * 类型（MENU：菜单，BUTTON：按钮）
     */
    @NotBlank(message = "参数type缺失")
    private String type;


    /**
     * 备注
     */
    private String desc;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 更新人
     */
    private String updateBy;


}