package com.auth.transfer.user;

import com.auth.model.User;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 修改密码
 *
 * @author Inori
 */

@Data
public class UserPasswordUpdateInVo {

    /**
     * 旧密码
     */
    @NotBlank(message = "参数oldPassword缺失")
    private String oldPassword;


    /**
     * 新密码
     */
    @NotBlank(message = "参数newPassword缺失")
    private String newPassword;


    /**
     * 用户
     */
    private User user;


}