package com.system.utils;

import com.core.config.ThreadLocalConfig;
import com.core.utils.StringUtil;
import com.system.dao.KingDeeLogMapper;
import com.system.transfer.kingdee.KingDeeLogCreateInVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * @author Inori
 */
@Component
public class KingDeeLogUtil {

    @Autowired
    private KingDeeLogMapper kingDeeLogMapper;


    public void kingDeeSynLogCreate(String kingDeeLogName, String request, List<List<Object>> response) {
        KingDeeLogCreateInVo inVo = new KingDeeLogCreateInVo();
        inVo.setName(kingDeeLogName);
        inVo.setRequest(request);
        inVo.setResponse(JsonUtil.toString(response));

        if (CollectionUtils.isEmpty(response)) {
            inVo.setFlag(0);
        } else if (response.get(0).get(0).toString().contains("Errors")) {
            inVo.setFlag(0);
            inVo.setMessage(KingDeeUtil.getMessage(response.get(0).get(0)));
        } else {
            inVo.setFlag(1);
        }

        Map<String, Object> temp = ThreadLocalConfig.get();
        int costTime = StringUtil.isNotNull(temp.get("costTime")) ? Integer.parseInt(temp.get("costTime").toString()) : 0;
        inVo.setCostTime(costTime);

        kingDeeLogMapper.kingDeeLogCreate(inVo);
    }

    public void kingDeePushLogCreate(String kingDeeLogName, String request, String response) {
        KingDeeLogCreateInVo inVo = new KingDeeLogCreateInVo();
        inVo.setName(kingDeeLogName);
        inVo.setRequest(request);
        inVo.setResponse(response);

        if (StringUtil.isNotBlank(response) && KingDeeUtil.isError(response)) {
            inVo.setFlag(0);
            inVo.setMessage(KingDeeUtil.getMessage(response));
        } else {
            inVo.setFlag(1);
        }

        Map<String, Object> temp = ThreadLocalConfig.get();
        int costTime = StringUtil.isNotNull(temp.get("costTime")) ? Integer.parseInt(temp.get("costTime").toString()) : 0;
        inVo.setCostTime(costTime);

        kingDeeLogMapper.kingDeeLogCreate(inVo);
    }


}
