package com.auth.controller;

import com.core.response.RestResponse;
import com.auth.serivce.ILoginService;
import com.auth.transfer.login.AuthLoginInVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "系统登陆")
@RestController
@RequestMapping("/api")
public class LoginController {

    @Autowired
    private ILoginService loginService;


    @ApiOperation("系统登陆")
    @PostMapping("/auth/login")
    public RestResponse authLogin(@RequestBody @Validated AuthLoginInVo inVo) {
        return loginService.authLogin(inVo);
    }

    @ApiOperation("登陆验证码")
    @GetMapping(value = "/auth/verify/code")
    public RestResponse authVerifyCode() {
        return loginService.authVerifyCode();
    }


}
