package com.auth.controller;

import com.auth.common.controller.BaseRestController;
import com.core.response.RestResponse;
import com.auth.serivce.IRoleService;
import com.auth.transfer.role.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 角色管理
 *
 * @author Inori
 */
@Api(tags = "角色管理")
@RestController
@RequestMapping("/api")
public class RoleController extends BaseRestController {

    @Autowired
    private IRoleService roleService;


    @ApiOperation("角色列表")
    @GetMapping("/role/list")
    public RestResponse roleList(@ModelAttribute @Validated RoleListInVo inVo) {
        RoleListOutVo outVo = roleService.roleList(this, inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("录入角色")
    @PostMapping("/role/create")
    public RestResponse roleCreate(@RequestBody @Validated RoleCreateInVo inVo) {
        inVo.setCreateBy(getUser().getName());
        return roleService.roleCreate(this, inVo);
    }

    @ApiOperation("修改角色")
    @PutMapping("/role/update")
    public RestResponse roleUpdate(@RequestBody @Validated RoleUpdateInVo inVo) {
        inVo.setUpdateBy(getUser().getName());
        return roleService.roleUpdate(this, inVo);
    }

    @ApiOperation("删除角色")
    @DeleteMapping("/role/delete")
    public RestResponse roleDelete(@ModelAttribute @Validated RoleDeleteInVo inVo) {
        return roleService.roleDelete(this, inVo);
    }

    @ApiOperation("获取角色权限树")
    @GetMapping("/role/permission/tree")
    public RestResponse rolePermissionTree(@ModelAttribute @Validated RolePermissionTreeInVo inVo) {
        RolePermissionTreeOutVo outVo = roleService.rolePermissionTree(this, inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("修改角色权限")
    @PutMapping("/role/permission/update")
    public RestResponse rolePermissionUpdate(@RequestBody @Validated RolePermissionUpdateInVo inVo) {
        return roleService.rolePermissionUpdate(this, inVo);
    }


}