package com.auth.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * 菜单表（含平台、菜单、按钮）
 *
 * @author Inori
 */
@TableName("tb_menu")
public class Menu {

    /**
     * 自增ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;


    /**
     * 编码
     */
    private String code;


    /**
     * 父编码
     */
    private String pcode;


    /**
     * 路径
     */
    private String path;


    /**
     * 名称
     */
    private String name;


    /**
     * 图标
     */
    private String icon;


    /**
     * 组件
     */
    private String assembly;


    /**
     * 排序
     */
    private Integer sortOrder;


    /**
     * 层级
     */
    private Integer level;


    /**
     * 类型（PLATFORM：平台，MENU：菜单，BUTTON：按钮）
     */
    private String type;


    /**
     * 备注
     */
    private String desc;


    /**
     * 状态（0：正常，-1：禁用）
     */
    private Integer status;


    /**
     * 创建时间
     */
    private String createTime;


    /**
     * 创建人
     */
    private String createBy;


    /**
     * 更新时间
     */
    private String updateTime;


    /**
     * 更新人
     */
    private String updateBy;


    /**
     * 权限
     */
    @TableField(exist = false)
    private Boolean permission;


    public Menu() {
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPcode() {
        return pcode;
    }

    public void setPcode(String pcode) {
        this.pcode = pcode;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getAssembly() {
        return assembly;
    }

    public void setAssembly(String assembly) {
        this.assembly = assembly;
    }

    public Integer getSortOrder() {
        return sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public Boolean getPermission() {
        return permission;
    }

    public void setPermission(Boolean permission) {
        this.permission = permission;
    }


}
