package com.auth.serivce.impl;

import com.auth.common.controller.BaseRestController;
import com.auth.dao.UserMapper;
import com.auth.model.User;
import com.auth.serivce.ILoginService;
import com.auth.transfer.login.AuthLoginInVo;
import com.auth.transfer.login.AuthLoginOutVo;
import com.auth.utils.JwtTokenUtil;
import com.auth.utils.Md5Util;
import com.auth.utils.RandImageUtil;
import com.auth.utils.ValidateCodeUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.core.response.RestResponse;
import com.core.utils.RedisUtil;
import com.core.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;

/**
 * @author Inori
 */
@Service
public class LoginServiceImpl implements ILoginService {

    @Autowired
    private UserMapper userMapper;

    @Autowired
    private RedisUtil redisUtil;


    @Override
    public RestResponse authLogin(AuthLoginInVo inVo) {
        String code = (String) redisUtil.get(Md5Util.encrypt(inVo.getCode().toLowerCase()));
        if (StringUtil.isBlank(code) || !code.equalsIgnoreCase(inVo.getCode())) {
            return RestResponse.fail("验证码错误");
        }

        QueryWrapper<User> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("account", inVo.getAccount());
        queryWrapper.eq("password", Md5Util.encrypt(inVo.getPassword() + inVo.getAccount()));

        User result = userMapper.selectOne(queryWrapper);
        if (StringUtil.isNull(result)) {
            return RestResponse.fail("账号或密码不正确");
        }
        if (result.getStatus() == -1) {
            return RestResponse.fail("该账号已禁用，请联系管理员");
        }

        AuthLoginOutVo outVo = new AuthLoginOutVo();
        outVo.setId(result.getId());
        outVo.setToken(JwtTokenUtil.generateToken(BaseRestController.TEMP + ":" + BaseRestController.ADMIN + ":" + result.getId().toString()));
        return RestResponse.success(outVo);
    }

    @Override
    public RestResponse authVerifyCode() {
        try {
            String code = ValidateCodeUtil.createRandom(false, 4);
            System.out.println("登陆验证码: " + code);
            //转小写
            String lowerCaseCode = code.toLowerCase();
            String key = Md5Util.encrypt(lowerCaseCode);
            redisUtil.set(key, code, 60);
            return RestResponse.success(RandImageUtil.generate(code));
        } catch (IOException e) {
            e.printStackTrace();
            return RestResponse.fail("验证码获取失败");
        }
    }


}
