package com.auth.serivce.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.core.constants.Constants;
import com.auth.common.controller.BaseRestController;
import com.core.response.RestResponse;
import com.auth.dao.RoleMapper;
import com.auth.dao.RoleMenuMapper;
import com.auth.model.Menu;
import com.auth.model.Role;
import com.auth.model.RoleMenu;
import com.auth.serivce.IRoleService;
import com.auth.transfer.role.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class RoleServiceImpl implements IRoleService {

    @Autowired
    private RoleMapper roleMapper;

    @Autowired
    private RoleMenuMapper roleMenuMapper;


    @Override
    public RoleListOutVo roleList(BaseRestController controller, RoleListInVo inVo) {
        Page<RoleListOutVoRecords> page = new Page<>(inVo.getPageNo(), inVo.getPageSize());
        List<RoleListOutVoRecords> recordsList = roleMapper.roleList(page, inVo);

        RoleListOutVo outVo = new RoleListOutVo();
        outVo.setTotal((int) page.getTotal());
        outVo.setRecords(recordsList);
        return outVo;
    }

    @Override
    public RestResponse roleCreate(BaseRestController controller, RoleCreateInVo inVo) {
        Role role = new Role();
        role.setName(inVo.getName());
        role.setSortOrder(inVo.getSortOrder());
        role.setDesc(inVo.getDesc());
        role.setCreateBy(inVo.getCreateBy());
        return roleHandle(role);
    }

    @Override
    public RestResponse roleUpdate(BaseRestController controller, RoleUpdateInVo inVo) {
        Role role = new Role();
        role.setId(inVo.getId());
        role.setName(inVo.getName());
        role.setSortOrder(inVo.getSortOrder());
        role.setDesc(inVo.getDesc());
        return roleHandle(role);
    }

    private RestResponse roleHandle(Role role) {
        Integer roleId = role.getId();
        if (roleId == null) {
            //新增
            Integer count = roleMapper.selectCount(new QueryWrapper<Role>()
                    .eq("name", role.getName())
                    .ne("status", -1));
            if (count > 0) {
                return RestResponse.fail("该角色名称已存在，请更换");
            }
            role.setStatus(0);
            roleMapper.insert(role);
        } else {
            //修改
            Integer count = roleMapper.selectCount(new QueryWrapper<Role>()
                    .eq("name", role.getName())
                    .ne("status", -1)
                    .ne("id", roleId));
            if (count > 0) {
                return RestResponse.fail("该角色名称已存在，请更换");
            }
            roleMapper.updateById(role);
        }
        return RestResponse.success();
    }

    @Override
    public RestResponse roleDelete(BaseRestController controller, RoleDeleteInVo inVo) {
        RestResponse checkUpdateStatus = checkUpdateStatus(inVo.getId());
        if (!checkUpdateStatus.isSuccess()) {
            return checkUpdateStatus;
        }

        roleMapper.deleteById(inVo.getId());
        return RestResponse.success();
    }

    private RestResponse checkUpdateStatus(Integer roleId) {
        Role role = roleMapper.selectById(roleId);
        if (role == null || role.getStatus() == -1) {
            return RestResponse.fail("角色不存在");
        }
        if (role.getBuiltIn() != null && role.getBuiltIn() == 1) {
            return RestResponse.fail("内置角色，不能修改");
        }
        return RestResponse.success();
    }

    @Override
    public RolePermissionTreeOutVo rolePermissionTree(BaseRestController controller, RolePermissionTreeInVo inVo) {
        List<Menu> menuList = roleMapper.getMenuListByRoleId(inVo.getId());

        List<RolePermissionTreeOutVoTreeRoot> allMenuList = menuList.stream().map(menu -> {
            RolePermissionTreeOutVoTreeRoot treeRoot = new RolePermissionTreeOutVoTreeRoot();
            treeRoot.setId(menu.getId());
            treeRoot.setCode(menu.getCode());
            treeRoot.setPcode(menu.getPcode());
            treeRoot.setPath(menu.getPath());
            treeRoot.setName(menu.getName());
            treeRoot.setType(menu.getType());
            treeRoot.setPermission(menu.getPermission());
            return treeRoot;
        }).collect(Collectors.toList());

        RolePermissionTreeOutVo menuTreeOutVo = new RolePermissionTreeOutVo();
        menuTreeOutVo.setTreeRoot(getMenuTree(String.valueOf(Constants.ROOT_MENU_CODE), allMenuList));
        return menuTreeOutVo;
    }

    private List<RolePermissionTreeOutVoTreeRoot> getMenuTree(String pcode, List<RolePermissionTreeOutVoTreeRoot> permissionMenuList) {
        List<RolePermissionTreeOutVoTreeRoot> rootList = permissionMenuList.stream().filter(m ->
                m.getPcode().equals(pcode)).collect(Collectors.toList()
        );
        for (RolePermissionTreeOutVoTreeRoot treeRoot : rootList) {
            treeRoot.setChildren(getMenuTree(treeRoot.getCode(), permissionMenuList));
        }
        return rootList;
    }

    @Override
    public RestResponse rolePermissionUpdate(BaseRestController controller, RolePermissionUpdateInVo inVo) {
        RestResponse checkUpdateStatus = checkUpdateStatus(inVo.getId());
        if (!checkUpdateStatus.isSuccess()) {
            return checkUpdateStatus;
        }

        roleMenuMapper.delete(new QueryWrapper<RoleMenu>().eq("role_id", inVo.getId()));
        for (Integer menuId : inVo.getMenuIdList()) {
            RoleMenu roleMenu = new RoleMenu();
            roleMenu.setMenuId(menuId);
            roleMenu.setRoleId(inVo.getId());
            roleMenuMapper.insert(roleMenu);
        }
        return RestResponse.success();
    }


}
