package com.auth.transfer.role;

import com.core.utils.StringUtil;

/**
 * 角色列表
 *
 * @author Inori
 */
public class RoleListInVo {

    /**
     * 角色名称
     */
    private String name;


    /**
     * 页码
     */
    private Integer pageNo;


    /**
     * 每页数量
     */
    private Integer pageSize;


    private static final Integer DEFAULT_PAGE_NO = 1;
    private static final Integer DEFAULT_PAGE_SIZE = 20;


    public RoleListInVo() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPageNo() {
        if (StringUtil.isNull(pageNo) || pageNo == -1) {
            return DEFAULT_PAGE_NO;
        }
        return pageNo;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public Integer getPageSize() {
        if (StringUtil.isNull(pageSize) || pageSize == -1) {
            return DEFAULT_PAGE_SIZE;
        }
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }


}