package com.auth.transfer.user;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户录入
 *
 * @author Inori
 */
@Data
public class UserCreateInVo {

    /**
     * 账号
     */
    @NotBlank(message = "参数account缺失")
    private String account;


    /**
     * 密码
     */
    @NotBlank(message = "参数password缺失")
    private String password;


    /**
     * 部门ID
     */
    private Integer deptId;


    /**
     * 姓名
     */
    @NotBlank(message = "参数name缺失")
    private String name;


    /**
     * 地址
     */
    private String address;


    /**
     * 手机号
     */
    private String mobile;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 角色列表
     */
    @NotNull(message = "参数roleIdList缺失")
    private List<Integer> roleIdList;


    /**
     * 创建人
     */
    private String createBy;


}