package com.auth.transfer.user;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 修改用户
 *
 * @author Inori
 */
@Data
public class UserUpdateInVo {

    /**
     * ID
     */
    @NotBlank(message = "参数id缺失")
    private Integer id;


    /**
     * 账号
     */
    @NotBlank(message = "参数account缺失")
    private String account;


    /**
     * 密码
     */
    private String password;


    /**
     * 部门ID
     */
    private Integer deptId;


    /**
     * 姓名
     */
    @NotBlank(message = "参数name缺失")
    private String name;


    /**
     * 地址
     */
    private String address;


    /**
     * 手机号
     */
    private String mobile;


    /**
     * 状态（0：正常，-1：禁用）
     */
    private Integer status;


    /**
     * 角色列表
     */
    @NotNull(message = "参数roleIdList缺失")
    private List<Integer> roleIdList;


    /**
     * 更新人
     */
    private String updateBy;


}