package com.system.api;

import com.core.utils.StringUtil;
import com.system.dao.InitConnectParamMapper;
import com.system.exception.KingDeeConnectException;
import com.system.model.InitConnectParam;
import com.system.utils.JsonUtil;
import com.system.utils.KingDeeLogUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Slf4j
@Component
public class KingDeeApi {

    private final String serviceNameTable = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutDataSet,LQKJ.WebApi.Stub";

    private final String serviceNameMap = "LQKJ.WebApi.Stub.CustomWebApiService.ExecuteDynamicObject,LQKJ.WebApi.Stub";

    private final String updateService = "LQKJ.WebApi.Stub.CustomWebApiService.ExecutBatch,LQKJ.WebApi.Stub";

    private InitConnectParam initConnectParam;

    private static final String LOGIN_MESSAGE = "金蝶服务器地址异常";

    public String thirdPartyUrl;

    public boolean flag = false;

    public KingDeeK3CloudApi kingDeeK3CloudApi;

    @Autowired
    private InitConnectParamMapper initConnectParamMapper;

    @Autowired
    private KingDeeLogUtil kingDeeLogUtil;


    @PostConstruct
    public void init() {
        initConnectParam = initConnectParamMapper.selectById("1");
        thirdPartyUrl = initConnectParam.getThirdPartyUrl();
        kingDeeK3CloudApi = new KingDeeK3CloudApi(initConnectParam.getK3CloudUrl());
    }

    public InitConnectParam getInitConnectParam() {
        return initConnectParam;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void setKingDeeK3CloudApi(KingDeeK3CloudApi kingDeeK3CloudApi) {
        this.kingDeeK3CloudApi = kingDeeK3CloudApi;
    }

    private String stringKey(Map<String, String> map) {
        StringBuilder keys = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(keys)) {
                keys.append(", ").append(entry.getKey());
            } else {
                keys = new StringBuilder(entry.getKey());
            }
        }
        if (StringUtil.isNotBlank(keys.toString())) {
            return "\"FieldKeys\":\"" + keys.toString() + "\"";
        }
        return "";
    }

    private String stringWhere(Map<String, String> map) {
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(where)) {
                where.append(" AND ").append(entry.getKey()).append("='").append(entry.getValue()).append("'");
            } else {
                where = new StringBuilder(entry.getKey() + "='" + entry.getValue() + "'");
            }
        }
        if (StringUtil.isNotBlank(where.toString())) {
            return ",\"FilterString\":\"" + where.toString() + "\"";
        }
        return "";
    }

    private String stringListWhere(Map<String, Object> map) {
        StringBuilder where = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (StringUtil.isNotBlank(where)) {
                if (entry.getValue() instanceof ArrayList) {
                    String str = JsonUtil.toList(JsonUtil.toString(entry.getValue()), Object.class).stream().map(m -> "'" + m + "'").collect(Collectors.joining(", "));
                    where.append(" AND ").append(entry.getKey()).append(" in(").append(str).append(")");
                } else {
                    where.append(" AND ").append(entry.getKey()).append("='").append(entry.getValue()).append("'");
                }
            } else {
                if (entry.getValue() instanceof ArrayList) {
                    String str = JsonUtil.toList(JsonUtil.toString(entry.getValue()), Object.class).stream().map(m -> "'" + m + "'").collect(Collectors.joining(", "));
                    where = new StringBuilder(entry.getKey() + " in(" + str + ")");
                } else {
                    where = new StringBuilder(entry.getKey() + "='" + entry.getValue() + "'");
                }

            }
        }
        if (StringUtil.isNotBlank(where.toString())) {
            return ",\"FilterString\":\"" + where.toString() + "\"";
        }
        return "";
    }

    /**
     * 查询单据体
     */
    public List<List<Object>> getKingDeeData(String sFormId, Map<String, String> key, Map<String, String> where) {
        try {
            if (this.flag) {
                System.out.println();
                String content = "{\"FormId\":\"" + sFormId + "\"," + stringKey(key) + stringWhere(where) + "}";
                System.out.println("==========content==========" + content + "==========content==========");
                List<List<Object>> result = kingDeeK3CloudApi.executeBillQuery(content);
                System.out.println("---------->" + JsonUtil.toString(result));
                return result;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }

    /**
     * 多查询单据体
     */
    public List<List<Object>> getKingDeeDataList(String sFormId, Map<String, String> key, Map<String, Object> where) {
        try {
            if (this.flag) {
                System.out.println();
                String content = "{\"FormId\":\"" + sFormId + "\"," + stringKey(key) + stringListWhere(where) + "}";
                System.out.println("==========content==========" + content + "==========content==========");
                List<List<Object>> result = kingDeeK3CloudApi.executeBillQuery(content);
                System.out.println();
                System.out.println("++++++++++result++++++++++" + JsonUtil.toString(result) + "++++++++++result++++++++++");
                System.out.println();
                return result;
            } else {
                throw new KingDeeConnectException(LOGIN_MESSAGE);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new KingDeeConnectException(LOGIN_MESSAGE);
        }
    }


}

