package com.system.controller;

import com.system.serivce.IPlugInUnitService;
import com.system.transfer.kingdee.KingDeeSynchronizationDataInVo;
import com.system.transfer.kingdee.KingDeeUpdateThirdDataInVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "金蝶插件")
@RestController
@RequestMapping("/api")
public class PlugInUnitController {

    @Autowired
    private IPlugInUnitService plugInUnitService;


    @ApiOperation(value = "物料插件")
    @PostMapping("/material/plug")
    public Object materialPlug(@RequestBody KingDeeUpdateThirdDataInVo inVo) {
        return plugInUnitService.materialPlug(inVo);
    }

    @ApiOperation(value = "生产用料清单插件")
    @PostMapping("/production/material/list/plug")
    public Object productionMaterialListPlug(@RequestBody KingDeeUpdateThirdDataInVo inVo) {
        return plugInUnitService.productionMaterialListPlug(inVo);
    }

    @ApiOperation(value = "生产领料补料退料单插件")
    @PostMapping("/production/picking/plug")
    public Object productionPickingPlug(@RequestBody KingDeeUpdateThirdDataInVo inVo) {
        return plugInUnitService.productionPickingPlug(inVo);
    }

    @ApiOperation(value = "生产入库单插件")
    @PostMapping("/production/warehousing/plug")
    public Object productionWarehousingPlug(@RequestBody KingDeeUpdateThirdDataInVo inVo) {
        return plugInUnitService.productionWarehousingPlug(inVo);
    }

    @ApiOperation(value = "物料清单插件")
    @PostMapping("/materials/list/plug")
    public Object materialsListPlug(@RequestBody KingDeeSynchronizationDataInVo inVo) {
        return plugInUnitService.materialsListPlug(inVo);
    }

    @ApiOperation(value = "供应商插件")
    @PostMapping("/supplier/list/plug")
    public Object supplierListPlug(@RequestBody KingDeeSynchronizationDataInVo inVo) {
        return plugInUnitService.supplierListPlug(inVo);
    }


}
