/*
SQLyog Enterprise v13.1.1 (64 bit)
MySQL - 5.7.6 : Database - db_semiconductor
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`db_semiconductor` /*!40100 DEFAULT CHARACTER SET utf8 */;

USE `db_semiconductor`;

/*Table structure for table `tb_user` */

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
	`id` INT(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
	`avatar` VARCHAR(255) DEFAULT NULL COMMENT '头像',
	`account` VARCHAR(128) DEFAULT NULL COMMENT '账号（支持中文、英文、数字）',
	`password` VARCHAR(128) DEFAULT NULL COMMENT '密码（MD5加密）',
	`salt` VARCHAR(64) DEFAULT NULL COMMENT 'MD5密码盐',
	`dept_id` int(11) DEFAULT NULL COMMENT '部门ID',
	`name` VARCHAR(64) DEFAULT NULL COMMENT '姓名',
	`birthday` DATETIME DEFAULT NULL COMMENT '生日',
	`sex` TINYINT(1) DEFAULT NULL COMMENT '性别',
	`mobile` VARCHAR(64) DEFAULT NULL COMMENT '手机号',
	`email` VARCHAR(64) DEFAULT NULL COMMENT '邮箱',
	`address` VARCHAR(255) DEFAULT NULL COMMENT '地址',
	`status` TINYINT(2) DEFAULT 0 COMMENT '状态（0：正常，-1：禁用）',
	`create_time` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
	`create_by` VARCHAR(64) DEFAULT NULL COMMENT '创建人',
	`update_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
	`update_by` VARCHAR(64) DEFAULT NULL COMMENT '更新人',
	PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COMMENT='系统用户表';

/*Data for the table `tb_user` */

/*Table structure for table `tb_user_role` */

DROP TABLE IF EXISTS `tb_user_role`;

CREATE TABLE `tb_user_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `user_id` int(11) DEFAULT NULL COMMENT '用户ID',
  `role_id` int(11) DEFAULT NULL COMMENT '角色ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户角色关系表';

/*Data for the table `tb_user_role` */

/*Table structure for table `tb_role` */

DROP TABLE IF EXISTS `tb_role`;

CREATE TABLE `tb_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(64) DEFAULT NULL COMMENT '角色名',
  `sort_order` int(11) DEFAULT NULL COMMENT '排序',
  `desc` varchar(255) DEFAULT NULL COMMENT '提示信息',
  `status` tinyint(2) DEFAULT '0' COMMENT '状态（0：正常，-1：废弃）',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '是否内置（1：是，0：否，内置不能删除）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='系统角色表';

/*Data for the table `tb_role` */

/*Table structure for table `tb_role_menu` */

DROP TABLE IF EXISTS `tb_role_menu`;

CREATE TABLE `tb_role_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `role_id` int(11) DEFAULT NULL COMMENT '角色ID',
  `menu_id` int(11) DEFAULT NULL COMMENT '菜单ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色菜单关系表';

/*Data for the table `tb_role_menu` */

/*Table structure for table `tb_menu` */

DROP TABLE IF EXISTS `tb_menu`;

CREATE TABLE `tb_menu` (
	`id` INT(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
	`pid` INT(11) DEFAULT NULL COMMENT '父ID',
	`name` VARCHAR(128) DEFAULT NULL COMMENT '名称',
    `path` VARCHAR(128) DEFAULT NULL COMMENT '名称',
	`icon` VARCHAR(128) DEFAULT NULL COMMENT '图标',
	`sort_order` INT(11) DEFAULT NULL COMMENT '排序',
	`level` INT(11) DEFAULT NULL COMMENT '层级',
	`type` VARCHAR(64) DEFAULT NULL COMMENT '类型（PLATFORM：平台，MENU：菜单，BUTTON：按钮）',
	`desc` VARCHAR(128) DEFAULT NULL COMMENT '备注',
	`status` TINYINT(2) DEFAULT 0 COMMENT '状态（0：正常，-1：禁用）',
	`create_time` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
	`create_by` VARCHAR(64) DEFAULT NULL COMMENT '创建人',
	`update_time` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
	`update_by` VARCHAR(64) DEFAULT NULL COMMENT '更新人',
	PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COMMENT='菜单表（含平台、菜单、按钮）';

/*Data for the table `tb_menu` */

/*Table structure for table `tb_dept` */

DROP TABLE IF EXISTS `tb_dept`;

CREATE TABLE `tb_dept` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `pid` int(11) DEFAULT NULL COMMENT '父节点ID',
  `name` varchar(128) DEFAULT NULL COMMENT '机构名称',
  `contacts` varchar(64) DEFAULT NULL COMMENT '联系人',
  `mobile` varchar(64) DEFAULT NULL COMMENT '手机号',
  `address` varchar(255) DEFAULT NULL COMMENT '机构地址',
  `desc` varchar(255) DEFAULT NULL COMMENT '备注',
  `sort_order` int(11) DEFAULT NULL COMMENT '排序，按照正序排列',
  `status` tinyint(2) DEFAULT '0' COMMENT '状态（0：正常，-1：禁用）',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建人',
  `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  `update_by` varchar(64) DEFAULT NULL COMMENT '更新人',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='部门表';

/*Data for the table `tb_dept` */