package com.auth.controller;

import com.auth.common.controller.BaseRestController;
import com.core.response.RestResponse;
import com.auth.serivce.IMenuService;
import com.auth.transfer.menu.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "菜单管理")
@RestController
@RequestMapping("/api")
public class MenuController extends BaseRestController {

    @Autowired
    private IMenuService menuService;


    @ApiOperation("菜单列表")
    @GetMapping("/menu/list")
    public RestResponse menuList(@ModelAttribute @Validated MenuListInVo inVo) {
        MenuListOutVo outVo = menuService.menuList(this, inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("录入菜单")
    @PostMapping("/menu/create")
    public RestResponse menuCreate(@RequestBody @Validated MenuCreateInVo inVo) {
        inVo.setCreateBy(getUser().getName());
        menuService.menuCreate(this, inVo);
        return RestResponse.success();
    }

    @ApiOperation("修改菜单")
    @PutMapping("/menu/update")
    public RestResponse menuUpdate(@RequestBody @Validated MenuUpdateInVo inVo) {
        inVo.setUpdateBy(getUser().getName());
        menuService.menuUpdate(this, inVo);
        return RestResponse.success();
    }

    @ApiOperation("删除菜单")
    @DeleteMapping("/menu/delete")
    public RestResponse menuDelete(@ModelAttribute @Validated MenuDeleteInVo inVo) {
        menuService.menuDelete(this, inVo);
        return RestResponse.success();
    }


}
