package com.auth.controller;

import com.auth.common.controller.BaseRestController;
import com.auth.serivce.IUserService;
import com.auth.transfer.user.*;
import com.core.response.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @author Inori
 */
@Api(tags = "用户管理")
@RestController
@RequestMapping("/api")
public class UserController extends BaseRestController {

    @Autowired
    private IUserService userService;


    @ApiOperation("用户列表")
    @GetMapping("/user/list")
    public RestResponse userList(@ModelAttribute @Validated UserListInVo inVo) {
        UserListOutVo outVo = userService.userList(this, inVo);
        return RestResponse.success(outVo);
    }

    @ApiOperation("用户录入")
    @PostMapping("/user/create")
    public RestResponse userCreate(@RequestBody @Validated UserCreateInVo inVo) {
        inVo.setCreateBy(getUser().getName());
        return userService.userCreate(this, inVo);
    }

    @ApiOperation("用户编辑")
    @PutMapping("/user/update")
    public RestResponse userUpdate(@RequestBody @Validated UserUpdateInVo inVo) {
        inVo.setUpdateBy(getUser().getName());
        return userService.userUpdate(this, inVo);
    }

    @ApiOperation("用户删除")
    @DeleteMapping("/user/delete")
    public RestResponse userDelete(@ModelAttribute @Validated UserDeleteInVo inVo) {
        inVo.setMe(getUserAccount());
        return userService.userDelete(this, inVo);
    }

    @ApiOperation("用户登录信息")
    @GetMapping("/user/info")
    public RestResponse userInfo() {
        UserInfoOutVo outVo = userService.userInfo(this, Integer.parseInt(getUserAccount()));
        return RestResponse.success(outVo);
    }

    @ApiOperation("用户登录权限")
    @GetMapping("/user/permission")
    public RestResponse userPermission() {
        UserPermissionOutVo outVo = userService.userPermission(this, Integer.parseInt(getUserAccount()));
        return RestResponse.success(outVo);
    }

    @ApiOperation("修改密码")
    @PutMapping("/user/password/update")
    public RestResponse userPasswordUpdate(@RequestBody @Validated UserPasswordUpdateInVo inVo) {
        inVo.setUser(getUser());
        return userService.userPasswordUpdate(this, inVo);
    }


}
