package com.auth.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.auth.model.Menu;
import com.auth.model.Role;
import com.auth.transfer.role.RoleListInVo;
import com.auth.transfer.role.RoleListOutVoRecords;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author Inori
 */
public interface RoleMapper extends BaseMapper<Role> {

    /**
     * 角色列表
     *
     * @param page 分页
     * @param inVo 条件
     * @return 列表
     */
    List<RoleListOutVoRecords> roleList(@Param("page") Page<RoleListOutVoRecords> page, @Param("inVo") RoleListInVo inVo);

    /**
     * 获取角色权限树
     *
     * @param roleId 角色ID
     * @return 角色权限树
     */
    List<Menu> getMenuListByRoleId(Integer roleId);

    /**
     * 用户登录权限
     *
     * @param userId 用户ID
     * @return 用户登录权限
     */
    List<Menu> getMenuListByUserId(Integer userId);


}