package com.auth.serivce;

import com.auth.common.controller.BaseRestController;
import com.core.response.RestResponse;
import com.auth.transfer.role.*;

/**
 * @author Inori
 */
public interface IRoleService {

    /**
     * 角色列表
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 列表
     */
    RoleListOutVo roleList(BaseRestController controller, RoleListInVo inVo);

    /**
     * 角色录入
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse roleCreate(BaseRestController controller, RoleCreateInVo inVo);

    /**
     * 角色编辑
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse roleUpdate(BaseRestController controller, RoleUpdateInVo inVo);

    /**
     * 角色删除
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse roleDelete(BaseRestController controller, RoleDeleteInVo inVo);

    /**
     * 获取角色权限树
     *
     * @param controller 枷锁
     * @param inVo       条件
     * @return 权限树
     */
    RolePermissionTreeOutVo rolePermissionTree(BaseRestController controller, RolePermissionTreeInVo inVo);

    /**
     *修改角色权限
     * @param controller 枷锁
     * @param inVo       条件
     * @return 结果
     */
    RestResponse rolePermissionUpdate(BaseRestController controller, RolePermissionUpdateInVo inVo);


}
