package com.auth.serivce.impl;

import com.core.constants.Constants;
import com.auth.common.controller.BaseRestController;
import com.auth.dao.DeptMapper;
import com.auth.model.Dept;
import com.auth.serivce.IDeptService;
import com.auth.transfer.dept.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Inori
 */
@Service
public class DeptServiceImpl implements IDeptService {

    @Autowired
    private DeptMapper deptMapper;


    @Override
    public DeptListOutVo deptList(BaseRestController baseRestController, DeptListInVo inVo) {
        List<DeptListOutVoRecords> recordsList = deptMapper.deptList(inVo);

        DeptListOutVo outVo = new DeptListOutVo();
        outVo.setTotal(recordsList.size());
        outVo.setRecords(getMenuTree(Constants.ROOT_MENU_CODE, recordsList));
        return outVo;
    }

    private List<DeptListOutVoRecords> getMenuTree(Integer pid, List<DeptListOutVoRecords> recordsList) {
        List<DeptListOutVoRecords> rootList = recordsList.stream().filter(m -> m.getPid().equals(pid)).collect(Collectors.toList());

        for (DeptListOutVoRecords records : rootList) {
            records.setChildren(getMenuTree(records.getId(), recordsList));
        }
        return rootList;
    }

    @Override
    public void deptCreate(BaseRestController baseRestController, DeptCreateInVo inVo) {
        Dept dept = new Dept();
        dept.setPid(inVo.getPid());
        dept.setName(inVo.getName());
        dept.setContacts(inVo.getContacts());
        dept.setMobile(inVo.getMobile());
        dept.setAddress(inVo.getAddress());
        dept.setDesc(inVo.getDesc());
        dept.setSortOrder(inVo.getSortOrder());
        dept.setStatus(inVo.getStatus());
        dept.setCreateBy(inVo.getCreateBy());

        deptMapper.insert(dept);
    }

    @Override
    public void deptUpdate(BaseRestController baseRestController, DeptUpdateInVo inVo) {
        Dept dept = new Dept();
        dept.setId(inVo.getId());
        dept.setPid(inVo.getPid());
        dept.setName(inVo.getName());
        dept.setMobile(inVo.getMobile());
        dept.setContacts(inVo.getContacts());
        dept.setAddress(inVo.getAddress());
        dept.setDesc(inVo.getDesc());
        dept.setSortOrder(inVo.getSortOrder());
        dept.setStatus(inVo.getStatus());
        dept.setUpdateBy(inVo.getUpdateBy());

        deptMapper.updateById(dept);
    }

    @Override
    public void deptDelete(BaseRestController baseRestController, DeptDeleteInVo inVo) {
        deptMapper.deleteById(inVo.getId());
    }


}
