package com.auth.transfer.menu;

import lombok.Data;

import java.util.List;

/**
 * 菜单记录
 *
 * @author Inori
 */
@Data
public class MenuListOutVoRecords {

    /**
     * ID
     */
    private Integer id;


    /**
     * 编码
     */
    private String code;


    /**
     * 父编码
     */
    private String pcode;


    /**
     * 名称
     */
    private String name;


    /**
     * 路径
     */
    private String path;


    /**
     * 图标
     */
    private String icon;


    /**
     * 组件
     */
    private String assembly;


    /**
     * 排序
     */
    private Integer sortOrder;


    /**
     * 层级
     */
    private Integer level;


    /**
     * 类型（MENU：菜单，BUTTON：按钮）
     */
    private String type;


    /**
     * 备注
     */
    private String desc;


    /**
     * 状态（0：正常，-1：禁用）
     */
    private Integer status;


    /**
     * 创建时间
     */
    private String createTime;


    /**
     * 子菜单
     */
    List<MenuListOutVoRecords> children;


}