package com.system.controller;

import com.core.response.RestResponse;
import com.system.serivce.IKingDeeLogService;
import com.system.transfer.kingdee.KingDeeLogListInVo;
import com.system.transfer.kingdee.KingDeeLogListOutVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Inori
 */
@Api(tags = "金蝶日志")
@RestController
@RequestMapping("/api")
public class KingDeeLogController {

    @Autowired
    private IKingDeeLogService kingDeeLogService;


    @ApiOperation("金蝶日志列表")
    @GetMapping("/kingdee/log/list")
    public RestResponse kingDeeLogList(@ModelAttribute @Validated KingDeeLogListInVo inVo) {
        KingDeeLogListOutVo outVo = kingDeeLogService.kingDeeLogList(inVo);
        return RestResponse.success(outVo);
    }


}
